/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.simplified;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import velox.api.layer1.common.Log;
import velox.api.layer1.simplified.CustomModule;
import velox.api.layer1.simplified.NumberConverter;
import velox.api.layer1.simplified.Parameter;
import velox.api.layer1.simplified.ParameterChangeListener;
import velox.api.layer1.simplified.SimplifiedL1ApiLoader;
import velox.api.layer1.simplified.UserSettings;
import velox.gui.StrategyPanel;
import velox.gui.colors.ColorsConfigItem;
import velox.gui.utils.localization.LocalizedBundleImplLeve1Api;

public class InstanceUtils {
    public static void setValuesFromSettings(UserSettings settings, Object instance, Class<? extends Annotation> annotationClass) {
        Field[] fieldList;
        Map<String, UserSettings.ParameterField> settingsMap = settings.getParameters();
        for (Field field : fieldList = instance.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            String fieldName = field.getName();
            UserSettings.ParameterField parameter = settingsMap.get(fieldName);
            Object value = null;
            if (parameter == null || parameter.getDefaultValue() == null || parameter.getClassName() == null) {
                parameter = new UserSettings.ParameterField();
                InstanceUtils.putDefaultFieldValue(field, instance, parameter);
                InstanceUtils.putClassValue(field, instance, parameter);
            }
            field.setAccessible(true);
            String name = parameter.getClassName();
            Class<?> clazz = null;
            try {
                clazz = Class.forName(name);
            }
            catch (ClassNotFoundException e1) {
                Log.error((String)"Failed to instantiate class", (Throwable)e1);
            }
            value = parameter.getDefaultValue();
            Class<?> valueClazz = value.getClass();
            if (valueClazz != clazz) {
                InstanceUtils.putDefaultFieldValue(field, instance, parameter);
                continue;
            }
            try {
                field.set(instance, value);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Log.error((String)"Failed to set a field", (Throwable)e);
            }
        }
    }

    public static Map<String, UserSettings.ParameterField> readSettingsFromAnnotations(Object instance, Class<? extends Annotation> annotationClass) {
        Field[] fieldList;
        HashMap<String, UserSettings.ParameterField> settingsMap = new HashMap<String, UserSettings.ParameterField>();
        for (Field field : fieldList = instance.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            field.setAccessible(true);
            UserSettings.ParameterField parameterMap = InstanceUtils.createParameterMap(annotationClass, field, instance);
            String parameterName = field.getName();
            settingsMap.put(parameterName, parameterMap);
        }
        return settingsMap;
    }

    private static UserSettings.ParameterField createParameterMap(Class<? extends Annotation> annotationClass, Field field, Object instance) {
        UserSettings.ParameterField parameterMap = null;
        try {
            parameterMap = (UserSettings.ParameterField)UserSettings.ParameterField.class.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            Log.error((String)"Failed to instantiate class", (Throwable)e);
        }
        InstanceUtils.putValuesFromAnnotation(annotationClass, field, parameterMap);
        InstanceUtils.putDefaultFieldValue(field, instance, parameterMap);
        InstanceUtils.putClassValue(field, instance, parameterMap);
        return parameterMap;
    }

    public static Map<String, UserSettings.ParameterField> readDefaultColorSettings(Object instance, Class<? extends Annotation> annotationClass) {
        Field[] fieldList;
        HashMap<String, UserSettings.ParameterField> settingsMap = new HashMap<String, UserSettings.ParameterField>();
        for (Field field : fieldList = instance.getClass().getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotationClass)) continue;
            Object object = new Object();
            field.setAccessible(true);
            try {
                object = field.get(instance);
            }
            catch (IllegalAccessException | IllegalArgumentException e1) {
                Log.error((String)"Failed to read a field", (Throwable)e1);
            }
            if (object.getClass() != Color.class) continue;
            String parameterName = field.getName();
            UserSettings.ParameterField parameterField = new UserSettings.ParameterField();
            InstanceUtils.putDefaultFieldValue(field, instance, parameterField);
            settingsMap.put(parameterName, parameterField);
        }
        return settingsMap;
    }

    private static void putValuesFromAnnotation(Class<? extends Annotation> annotationClass, Field field, UserSettings.ParameterField parameterMap) {
        Annotation annotation = field.getAnnotation(annotationClass);
        Parameter parameter = (Parameter)annotation;
        parameterMap.setParameterName(parameter.name());
        parameterMap.setStep(parameter.step());
        parameterMap.setReloadIfChanged(parameter.reloadOnChange());
    }

    private static void putDefaultFieldValue(Field field, Object object, UserSettings.ParameterField parameterField) {
        try {
            field.setAccessible(true);
            Object defaultValue = field.get(object);
            parameterField.setDefaultValue(defaultValue);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Log.error((String)"Failed to read a field", (Throwable)e);
        }
    }

    private static void putClassValue(Field field, Object object, UserSettings.ParameterField parameterField) {
        try {
            Class<?> clazz = field.getType();
            String str = clazz.getCanonicalName();
            parameterField.setClassName(str);
        }
        catch (IllegalArgumentException e) {
            Log.error((String)"Failed to put class value", (Throwable)e);
        }
    }

    public static StrategyPanel getColorPanel(CustomModule instance, SimplifiedL1ApiLoader<? extends CustomModule> apiLoader, String alias) {
        Field[] fieldList;
        UserSettings userSettings = apiLoader.getUserSettings(alias);
        Map<String, UserSettings.ParameterField> previousParameters = userSettings.getParameters();
        LocalizedBundleImplLeve1Api localizedBundle = LocalizedBundleImplLeve1Api.getInstance();
        StrategyPanel panel = new StrategyPanel(localizedBundle.getString("InstanceUtils.StrategyPanel.ColorSettings"), (LayoutManager)new GridBagLayout());
        panel.setLayout((LayoutManager)new GridBagLayout());
        int colorsAdded = 0;
        for (Field field : fieldList = instance.getClass().getDeclaredFields()) {
            Color defaultColor;
            Class<?> clazz = field.getType();
            if (clazz != Color.class || !field.isAnnotationPresent(Parameter.class)) continue;
            Object value = null;
            try {
                field.setAccessible(true);
                value = field.get(instance);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Log.error((String)"Failed to read a field", (Throwable)e);
            }
            Color color = (Color)value;
            Parameter parameter = field.getAnnotation(Parameter.class);
            String colorName = parameter.name();
            String fieldName = field.getName();
            UserSettings.ParameterField parameterField = previousParameters.get(fieldName);
            boolean isUpdated = false;
            if (parameterField != null) {
                defaultColor = (Color)parameterField.getDefaultValue();
            } else {
                defaultColor = color;
                UserSettings.ParameterField map = InstanceUtils.createParameterMap(Parameter.class, field, instance);
                previousParameters.put(fieldName, map);
                isUpdated = true;
            }
            if (isUpdated) {
                apiLoader.settingsChanged(alias, userSettings);
            }
            ColorsConfigItem configItemLines = new ColorsConfigItem(color, defaultColor, null, newColor -> {
                try {
                    field.set(instance, newColor);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw new RuntimeException(e);
                }
                UserSettings settinds = apiLoader.createUserSettingsFromAnnotations(instance, Parameter.class, alias, true);
                if (!newColor.equals(color)) {
                    apiLoader.settingsChanged(alias, settinds);
                    if (instance instanceof ParameterChangeListener) {
                        ((ParameterChangeListener)((Object)instance)).onParameterChanged(colorName);
                    }
                    if (parameter.reloadOnChange()) {
                        apiLoader.restartInstrument(alias);
                    }
                }
            });
            JLabel nameLabel = new JLabel(colorName);
            panel.add((Component)nameLabel, (Object)InstanceUtils.getConstraintsForColors(0, colorsAdded));
            panel.add((Component)configItemLines, (Object)InstanceUtils.getConstraintsForColors(1, colorsAdded));
            ++colorsAdded;
        }
        if (colorsAdded == 0) {
            panel = null;
        }
        return panel;
    }

    public static StrategyPanel addCustomGui(Object instance, UserSettings settings, String panelName, String alias, SimplifiedL1ApiLoader<?> apiLoader) {
        Field[] fieldList = instance.getClass().getDeclaredFields();
        StrategyPanel innerPanel = new StrategyPanel(panelName, (LayoutManager)new GridBagLayout());
        int parametersAdded = 0;
        ArrayList<Boolean> flags = new ArrayList<Boolean>();
        HashMap<Field, Object> fieldsAndSpinners = new HashMap<Field, Object>();
        LocalizedBundleImplLeve1Api localizedBundle = LocalizedBundleImplLeve1Api.getInstance();
        JButton button = new JButton(localizedBundle.getString("InstanceUtils.JButton.ApplyCustomGui"));
        button.setEnabled(false);
        for (Field field : fieldList) {
            Class<?> type;
            if (!field.isAnnotationPresent(Parameter.class)) continue;
            flags.add(false);
            Parameter parameter = field.getAnnotation(Parameter.class);
            field.setAccessible(true);
            String name = parameter.name();
            JLabel jlabel = new JLabel(name);
            Class<?> clazz = type = field.getType();
            JComponent component = null;
            if (Number.class.isAssignableFrom(clazz)) {
                JSpinner spinner;
                component = spinner = InstanceUtils.setNumericalSpinner(clazz, field, instance, parameter, fieldsAndSpinners, button, flags, parametersAdded);
            } else if (String.class.isAssignableFrom(clazz)) {
                JTextField textField = InstanceUtils.setTextField(field, instance, parameter, fieldsAndSpinners, button, flags, parametersAdded);
                component = textField;
            } else if (Boolean.class.isAssignableFrom(clazz)) {
                JCheckBox checkBox = InstanceUtils.setCheckBox(field, instance, parameter, fieldsAndSpinners, button, flags, parametersAdded);
                component = checkBox;
            } else if (Color.class.isAssignableFrom(clazz)) continue;
            innerPanel.add((Component)jlabel, (Object)InstanceUtils.getConstraints(0, parametersAdded));
            innerPanel.add((Component)component, (Object)InstanceUtils.getConstraints(1, parametersAdded));
            ++parametersAdded;
        }
        if (parametersAdded == 0) {
            return null;
        }
        InstanceUtils.addActionListener(instance, fieldsAndSpinners, button, flags, alias, apiLoader);
        GridBagConstraints buttonConstraints = InstanceUtils.getConstraints(1, parametersAdded + 1);
        buttonConstraints.fill = 0;
        innerPanel.add((Component)button, (Object)buttonConstraints);
        GridBagConstraints panelConstraints = new GridBagConstraints();
        panelConstraints.weightx = 1.0;
        panelConstraints.weighty = 1.0;
        panelConstraints.insets = new Insets(3, 0, 5, 13);
        panelConstraints.fill = 1;
        StrategyPanel outerPanel = new StrategyPanel(panelName);
        outerPanel.setLayout((LayoutManager)new GridBagLayout());
        outerPanel.add((Component)innerPanel, (Object)panelConstraints);
        return outerPanel;
    }

    private static <T> JSpinner setNumericalSpinner(Class<T> clazz, final Field field, final Object source, Parameter parameter, Map<Field, Object> fieldsAndSpinners, final JButton button, final List<Boolean> flags, int y) {
        Number value = null;
        Number objValue = null;
        try {
            field.setAccessible(true);
            objValue = (Number)field.get(source);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Log.error((String)"Failed to read a field", (Throwable)e);
        }
        value = objValue;
        Object stepSize = NumberConverter.convert(parameter.step(), clazz);
        Comparable<Integer> minimum = 0;
        minimum = Double.isNaN(parameter.minimum()) ? (Comparable)NumberConverter.convert(0, clazz) : (Comparable)NumberConverter.convert(parameter.minimum(), clazz);
        Comparable maximum = Double.isNaN(parameter.maximum()) ? (Comparable)((Object)NumberConverter.getMaxTypeValue(clazz)) : (Comparable)NumberConverter.convert(parameter.maximum(), clazz);
        SpinnerNumberModel sModel = new SpinnerNumberModel(value, minimum, maximum, (Number)stepSize);
        JSpinner spinner = new JSpinner(sModel);
        ((JSpinner.DefaultEditor)spinner.getEditor()).getTextField().setColumns(8);
        fieldsAndSpinners.put(field, spinner);
        final int index = y;
        spinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                Object eventSource = event.getSource();
                JSpinner sp = (JSpinner)eventSource;
                Number tempValue = (Number)sp.getValue();
                Object comparable = null;
                try {
                    Object obTemp;
                    comparable = obTemp = field.get(source);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    Log.error((String)"Failed to read a field", (Throwable)e);
                }
                if (tempValue.equals(comparable)) {
                    flags.set(index, false);
                } else {
                    flags.set(index, true);
                }
                boolean isEnabled = false;
                Iterator iterator = flags.iterator();
                while (iterator.hasNext()) {
                    boolean flag = (Boolean)iterator.next();
                    if (!flag) continue;
                    isEnabled = true;
                }
                button.setEnabled(isEnabled);
            }
        });
        return spinner;
    }

    private static <T> void addActionListener(Object instance, Map<Field, Object> fieldsAndSpinners, JButton button, List<Boolean> flags, String alias, SimplifiedL1ApiLoader<? extends CustomModule> apiLoader) {
        button.addActionListener(e -> {
            for (Field field : fieldsAndSpinners.keySet()) {
                Class<?> type;
                Class<?> clazz = type = field.getType();
                Object value = null;
                if (Number.class.isAssignableFrom(clazz)) {
                    JSpinner spinner = (JSpinner)fieldsAndSpinners.get(field);
                    Number spinnerValue = (Number)spinner.getValue();
                    value = NumberConverter.convert(spinnerValue, clazz);
                } else if (Boolean.class.isAssignableFrom(clazz)) {
                    JCheckBox checkBox = (JCheckBox)fieldsAndSpinners.get(field);
                    value = checkBox.isSelected();
                } else if (String.class.isAssignableFrom(clazz)) {
                    JTextField textField = (JTextField)fieldsAndSpinners.get(field);
                    value = textField.getText();
                }
                try {
                    field.set(instance, value);
                }
                catch (IllegalAccessException | IllegalArgumentException e1) {
                    Log.error((String)"Failed to set a field", (Throwable)e1);
                }
            }
            UserSettings settings = apiLoader.createUserSettingsFromAnnotations(instance, Parameter.class, alias, true);
            Map<String, UserSettings.ParameterField> newParameters = settings.getParameters();
            Map<String, UserSettings.ParameterField> previousParameters = apiLoader.getUserSettings(alias).getParameters();
            boolean isChanged = false;
            for (Map.Entry<String, UserSettings.ParameterField> entry : newParameters.entrySet()) {
                UserSettings.ParameterField previousParameter = previousParameters.get(entry.getKey());
                UserSettings.ParameterField newParameter = entry.getValue();
                if (previousParameter != null && previousParameter.getDefaultValue() != null && previousParameter.getDefaultValue().equals(newParameter.getDefaultValue())) continue;
                if (instance instanceof ParameterChangeListener) {
                    ((ParameterChangeListener)instance).onParameterChanged(newParameter.getParameterName());
                }
                if (!newParameter.isReloadIfChanged()) continue;
                isChanged = true;
            }
            apiLoader.settingsChanged(alias, settings);
            if (isChanged) {
                apiLoader.restartInstrument(alias);
            }
            for (int i = 0; i < flags.size(); ++i) {
                flags.set(i, false);
            }
            button.setEnabled(false);
        });
    }

    private static GridBagConstraints getConstraints(int x, int y) {
        GridBagConstraints gbConst = new GridBagConstraints();
        InstanceUtils.setDefaultConstraints(gbConst, x, y);
        if (x == 1) {
            gbConst.anchor = 13;
            gbConst.weightx = 0.26;
            gbConst.fill = 2;
        }
        return gbConst;
    }

    private static GridBagConstraints getConstraintsForColors(int x, int y) {
        GridBagConstraints gbConst = new GridBagConstraints();
        InstanceUtils.setDefaultConstraints(gbConst, x, y);
        if (x == 1) {
            gbConst.anchor = 13;
        }
        gbConst.fill = 3;
        return gbConst;
    }

    private static void setDefaultConstraints(GridBagConstraints gbConst, int x, int y) {
        gbConst.gridx = x;
        gbConst.gridy = y;
        gbConst.weightx = 1.0;
        gbConst.weighty = 1.0;
        gbConst.insets = new Insets(5, 5, 5, 5);
        gbConst.anchor = 17;
    }

    private static JCheckBox setCheckBox(Field field, final Object source, Parameter parameter, Map<Field, Object> fieldsAndSpinners, final JButton button, final List<Boolean> flags, int y) {
        Boolean isBoxSelected = false;
        try {
            isBoxSelected = (Boolean)field.get(source);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Log.error((String)"Failed to read a field", (Throwable)e);
        }
        JCheckBox checkBox = new JCheckBox("");
        checkBox.setSelected(isBoxSelected);
        fieldsAndSpinners.put(field, checkBox);
        Field[] workaroundArray = new Field[]{field};
        final Field workaroundAnnotatedField = workaroundArray[0];
        final int index = y;
        checkBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                Boolean isSelected = event.getStateChange() == 1 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                Boolean comparable = null;
                try {
                    comparable = (Boolean)workaroundAnnotatedField.get(source);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    Log.error((String)"Failed to read a field", (Throwable)e);
                }
                if (isSelected.equals(comparable)) {
                    flags.set(index, false);
                } else {
                    flags.set(index, true);
                }
                boolean isEnabled = false;
                Iterator iterator = flags.iterator();
                while (iterator.hasNext()) {
                    boolean flag = (Boolean)iterator.next();
                    if (!flag) continue;
                    isEnabled = true;
                }
                button.setEnabled(isEnabled);
            }
        });
        return checkBox;
    }

    private static JTextField setTextField(Field field, final Object source, Parameter parameter, Map<Field, Object> fieldsAndSpinners, final JButton button, final List<Boolean> flags, int y) {
        String defaultValue = "";
        try {
            defaultValue = (String)field.get(source);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            Log.error((String)"Failed to read a field", (Throwable)e);
        }
        final JTextField textField = new JTextField(defaultValue, 9);
        fieldsAndSpinners.put(field, textField);
        Field[] workaroundArray = new Field[]{field};
        final Field workaroundAnnotatedField = workaroundArray[0];
        final int index = y;
        textField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent event) {
                String content = textField.getText();
                String comparable = "";
                try {
                    comparable = (String)workaroundAnnotatedField.get(source);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    Log.error((String)"Failed to read a field", (Throwable)e);
                }
                if (content.equals(comparable)) {
                    flags.set(index, false);
                } else {
                    flags.set(index, true);
                }
                boolean isEnabled = false;
                Iterator iterator = flags.iterator();
                while (iterator.hasNext()) {
                    boolean flag = (Boolean)iterator.next();
                    if (!flag) continue;
                    isEnabled = true;
                }
                button.setEnabled(isEnabled);
            }
        });
        return textField;
    }

    public static boolean isTypeAllowed(Class<?> simpleStrategyClass, Field field) {
        Class[] clazzes;
        for (Class clazz : clazzes = new Class[]{Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, Boolean.class, Color.class}) {
            if (field.getType() != clazz) continue;
            return true;
        }
        return false;
    }

    public static void isTypeAllowed(Class<?> simpleStrategyClass, Class<? extends Annotation> annotationClass) {
        Field[] fieldList;
        for (Field field : fieldList = simpleStrategyClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(annotationClass) || InstanceUtils.isTypeAllowed(simpleStrategyClass, field)) continue;
            throw new RuntimeException(field.getType().getCanonicalName() + " is an invalid field type for the Parameter annotation in the\n" + simpleStrategyClass.getSimpleName() + " class.\nOnly Numeric Objects, Boolean, String and Color types allowed");
        }
    }
}

