/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.simplified;

import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class AxisRules {
    private double forcedMin = Double.NaN;
    private double forcedMax = Double.NaN;
    private double includedMin = Double.NaN;
    private double includedMax = Double.NaN;
    private double margin = 0.0;
    private boolean symmetrical = false;

    public double getForcedMin() {
        return this.forcedMin;
    }

    public void setForcedMin(double forcedMin) {
        this.forcedMin = forcedMin;
    }

    public double getForcedMax() {
        return this.forcedMax;
    }

    public void setForcedMax(double forcedMax) {
        this.forcedMax = forcedMax;
    }

    public double getIncludedMin() {
        return this.includedMin;
    }

    public void setIncludedMin(double includedMin) {
        this.includedMin = includedMin;
    }

    public double getIncludedMax() {
        return this.includedMax;
    }

    public void setIncludedMax(double includedMax) {
        this.includedMax = includedMax;
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double margin) {
        this.margin = margin;
    }

    public boolean isSymmetrical() {
        return this.symmetrical;
    }

    public void setSymmetrical(boolean symmetrical) {
        this.symmetrical = symmetrical;
    }

    public Pair<Double, Double> apply(double min, double max) {
        double expansionValue;
        boolean maxLocked;
        boolean minLocked = !Double.isNaN(this.forcedMin);
        boolean bl = maxLocked = !Double.isNaN(this.forcedMax);
        if (minLocked) {
            min = this.forcedMin;
        }
        if (maxLocked) {
            max = this.forcedMax;
        }
        if (!minLocked && !Double.isNaN(this.includedMin)) {
            min = Math.min(min, this.includedMin);
        }
        if (!maxLocked && !Double.isNaN(this.includedMax)) {
            max = Math.max(max, this.includedMax);
        }
        if (!minLocked && !maxLocked && this.isSymmetrical()) {
            min = Math.min(min, -max);
            max = Math.max(max, -min);
        }
        if ((expansionValue = (this.includedMax - this.includedMin) * this.margin) > 0.0) {
            if (!minLocked && !maxLocked) {
                min -= expansionValue / 2.0;
                max += expansionValue / 2.0;
            }
            if (minLocked && !maxLocked) {
                max += expansionValue;
            }
            if (maxLocked && !minLocked) {
                min -= expansionValue;
            }
        }
        return new ImmutablePair((Object)min, (Object)max);
    }
}

