/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.simplified;

public class Bar {
    private double open;
    private double close;
    private double high;
    private double low;
    private long volumeBuy;
    private long volumeSell;
    private double volumePremultipliedPriceBuy;
    private double volumePremultipliedPriceSell;

    public Bar(Bar other) {
        this.open = other.open;
        this.close = other.close;
        this.high = other.high;
        this.low = other.low;
        this.volumeBuy = other.volumeBuy;
        this.volumeSell = other.volumeSell;
        this.volumePremultipliedPriceBuy = other.volumePremultipliedPriceBuy;
        this.volumePremultipliedPriceSell = other.volumePremultipliedPriceSell;
    }

    public Bar(double openPrice) {
        this.initPrice(openPrice);
    }

    public Bar() {
        this(Double.NaN);
    }

    private void initPrice(double openPrice) {
        this.high = this.low = openPrice;
        this.close = this.low;
        this.open = this.low;
    }

    public void addTrade(boolean isBuy, long volume, double price) {
        if (Double.isNaN(this.open)) {
            this.high = this.low = price;
            this.open = this.low;
        }
        this.high = Math.max(price, this.high);
        this.low = Math.min(price, this.low);
        this.close = price;
        if (isBuy) {
            this.volumeBuy += volume;
            this.volumePremultipliedPriceBuy += (double)volume * price;
        } else {
            this.volumeSell += volume;
            this.volumePremultipliedPriceSell += (double)volume * price;
        }
    }

    public void startNext() {
        this.initPrice(this.close);
        this.volumeSell = 0L;
        this.volumeBuy = 0L;
        this.volumePremultipliedPriceSell = 0.0;
        this.volumePremultipliedPriceBuy = 0.0;
    }

    public double getOpen() {
        return this.open;
    }

    public void setOpen(double open) {
        this.open = open;
    }

    public double getClose() {
        return this.close;
    }

    public void setClose(double close) {
        this.close = close;
    }

    public double getHigh() {
        return this.high;
    }

    public void setHigh(double high) {
        this.high = high;
    }

    public double getLow() {
        return this.low;
    }

    public void setLow(double low) {
        this.low = low;
    }

    public long getVolumeBuy() {
        return this.volumeBuy;
    }

    public void setVolumeBuy(long volumeBuy) {
        this.volumeBuy = volumeBuy;
    }

    public long getVolumeSell() {
        return this.volumeSell;
    }

    public void setVolumeSell(long volumeSell) {
        this.volumeSell = volumeSell;
    }

    public long getVolumeTotal() {
        return this.volumeBuy + this.volumeSell;
    }

    public double getVwapBuy() {
        return this.volumePremultipliedPriceBuy / (double)this.volumeBuy;
    }

    public double getVwapSell() {
        return this.volumePremultipliedPriceSell / (double)this.volumeSell;
    }

    public double getVwap() {
        return (this.volumePremultipliedPriceBuy + this.volumePremultipliedPriceSell) / (double)(this.volumeBuy + this.volumeSell);
    }
}

