/*
 * Decompiled with CFR 0.152.
 */
package velox.api.layer1.simplified;

import velox.api.layer1.messages.indicators.IndicatorLineStyle;
import velox.gui.utils.localization.translatable.Layer1ApiTranslatableText;

public enum LineStyle {
    SOLID(new Layer1ApiTranslatableText("LineStyle.Enum.Solid"), IndicatorLineStyle.DEFAULT),
    SHORT_DASH(new Layer1ApiTranslatableText("LineStyle.Enum.ShortDash"), new IndicatorLineStyle(-256, 1, 0, -3856, 1, 0)),
    LONG_DASH(new Layer1ApiTranslatableText("LineStyle.Enum.LongDash"), new IndicatorLineStyle(-256, 2, 0, -256, 1, 0)),
    DOT(new Layer1ApiTranslatableText("LineStyle.Enum.Dot"), new IndicatorLineStyle(21845, 2, 0, 21845, 1, 0)),
    DASH_DOT(new Layer1ApiTranslatableText("LineStyle.Enum.DashDot"), new IndicatorLineStyle(-171, 2, 0, -171, 1, 0));

    private final Layer1ApiTranslatableText stringRepresentation;
    private final IndicatorLineStyle baseStyle;

    private LineStyle(Layer1ApiTranslatableText stringRepresentation, IndicatorLineStyle baseStyle) {
        this.stringRepresentation = stringRepresentation;
        this.baseStyle = baseStyle;
    }

    public IndicatorLineStyle toIndicatorStyle(int width) {
        return new IndicatorLineStyle(this.baseStyle.mainLineStyleMask, this.baseStyle.mainLineStyleMultiplier, width, this.baseStyle.rightLineStyleMask, this.baseStyle.rightLineStyleMultiplier, width);
    }

    public String toString() {
        return this.stringRepresentation.toDefaultString();
    }

    public String toLocalizedString() {
        return this.stringRepresentation.toLocalizedString();
    }
}

